/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.upgrddat;

import com.ibm.hwmca.base.settings.network.NetworkInfo;
import com.ibm.hwmca.base.upgrddat.UpgradeDataBean;
import com.ibm.hwmca.base.upgrddat.UpgradeDataConstants;
import com.ibm.hwmca.base.upgrddat.UpgradeDataErrorIds;
import com.ibm.hwmca.base.upgrddat.UpgradeDataFilter;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseMessageTitle;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkEventText;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.SystemEventLog;
import com.ibm.hwmca.fw.managed.ClassId;
import com.ibm.hwmca.fw.managed.HwmcaObject;
import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.managed.Tower;
import com.ibm.hwmca.fw.managed.User;
import com.ibm.hwmca.fw.mediasvc.MediaDevice;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceException;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceIdentifier;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceLockException;
import com.ibm.hwmca.fw.mediasvc.MediaServices;
import com.ibm.hwmca.fw.mediasvc.MediaWriteProtectedException;
import com.ibm.hwmca.fw.mediasvc.NoMediaPresentException;
import com.ibm.hwmca.fw.task.PresentationTaskParms;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.upgrddat.UpgradeData;
import com.ibm.hwmca.fw.upgrddat.UpgradeDataException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.Trace;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class UpgradeDataTasklet
extends PanelTasklet
implements UpgradeDataErrorIds,
UpgradeDataConstants {
    private static final String RES_BUNDLE_NAME = "com.ibm.hwmca.base.res.message";
    private static final String INTERFACE_NAME = "com.ibm.hwmca.fw.upgrddat.UpgradeData";
    private static final String TRACE_MASKT = "XSAVUPTT";
    private static final String TRACE_MASKF = "XSAVUPTF";
    private static final String TRACE_MASKD = "XSAVUPTD";
    public static final String PANEL_TITLE = "SAV80001";
    public static final String BUSY_MSG1 = "SAV80006";
    private static final String AUIML_FILE_NAME = "com.ibm.hwmca.base.upgrddat.res.UpgradeDataRes";
    private static final String PANEL_NAME = "UpgradeDataPanel";
    private String filePrefix = "UpgradeData.";
    private String fileNameZip = "UpgradeDataAllTowers.zip";
    private List implList = null;
    private static FrameworkClassLogInfo _logInfo = new FrameworkClassLogInfo(3, "UpgradeDataTasklet");
    MediaDevice upgrDevice = null;
    MediaDevice upgrDeviceDVD = null;
    MediaDevice upgrDeviceDOS = null;
    private PresentationTaskParms parms;
    public String Platform = null;

    public UpgradeDataTasklet() {
        Trace.trace(TRACE_MASKT, "-> UpgradeDataTasklet constructor");
        NetworkInfo NetworkInfo2 = new NetworkInfo();
        this.Platform = NetworkInfo2.getPlatform();
        Trace.trace(TRACE_MASKF, "Platform is : " + this.Platform);
        Trace.trace(TRACE_MASKT, "<- UpgradeDataTasklet constructor");
    }

    /*
     * WARNING - void declaration
     */
    public void service(PanelTaskletRequest taskletRequest, PanelTaskletResponse taskletResponse) throws TaskletException {
        block48: {
            Trace.trace(TRACE_MASKT, "-> UpgradeDataTasklet.service()");
            if (taskletRequest.isInitialRequest()) {
                Trace.trace(TRACE_MASKF, "-> UpgradeDataTasklet.isInitialRequest()");
                UpgradeDataBean bean = new UpgradeDataBean();
                bean.setBeanName("UpgradeDataBean");
                taskletResponse.replace(AUIML_FILE_NAME, PANEL_NAME, bean);
                Trace.trace(TRACE_MASKF, "<- UpgradeDataTasklet.isInitialRequest()");
            } else {
                Trace.trace(TRACE_MASKF, "taskletRequest.getData(): " + taskletRequest.getData("event") + ".");
                Trace.trace(TRACE_MASKF, "taskletRequest.getData(): " + taskletRequest.getData("radiobutton") + ".");
                Trace.trace(TRACE_MASKF, "taskletRequest.getData(): " + taskletRequest.getData("NO") + ".");
                if (taskletRequest.isDisposed() || taskletRequest.isCanceled()) {
                    Trace.trace(TRACE_MASKF, "taskletRequest.isDisposed() or isCanceled, issue taskletResponse.terminate.");
                    taskletResponse.terminate();
                } else {
                    Trace.trace(TRACE_MASKF, "Some taskletRequest other than Cancel is pending.");
                    String event = (String)taskletRequest.getData("event");
                    String checkbox = (String)taskletRequest.getData("NO");
                    String radiobutton = (String)taskletRequest.getData("radiobutton");
                    boolean stop = false;
                    Trace.trace(TRACE_MASKF, "event is " + event);
                    Trace.trace(TRACE_MASKF, "radiobutton is " + radiobutton);
                    Trace.trace(TRACE_MASKF, "checkbox is " + checkbox);
                    if (event.equals("OkButton")) {
                        Trace.trace(TRACE_MASKF, "OK button found tasklet side.");
                        try {
                            Trace.trace(TRACE_MASKF, "radiobutton for ok_button equals " + radiobutton);
                            Trace.trace(TRACE_MASKF, "DVD_BUTTON for ok_button equals DVDItem");
                            if (radiobutton.equals("DVDItem")) {
                                Trace.trace(TRACE_MASKF, "DVD radio button found tasklet side.");
                                int mountDVD_error = 0;
                                Trace.trace(TRACE_MASKF, "Mount the DVD");
                                mountDVD_error = this.mountDVD();
                                Trace.trace(TRACE_MASKF, "mountDVD_error is : " + mountDVD_error);
                                if (mountDVD_error != 0) {
                                    stop = true;
                                    this.saveupgradeMessages(mountDVD_error);
                                    try {
                                        Trace.trace(TRACE_MASKF, "Unmount DVD");
                                        this.upgrDeviceDVD.unmount();
                                        this.upgrDeviceDVD.unlock();
                                    }
                                    catch (Exception e) {
                                        Trace.trace(TRACE_MASKF, "An Exception on unmounting DVD");
                                        Trace.trace(TRACE_MASKT, "<-> Error message is : " + e.getMessage());
                                    }
                                    if (mountDVD_error == 5 || mountDVD_error == 8 || mountDVD_error == 10) {
                                        taskletResponse.terminate();
                                    } else {
                                        taskletResponse.noAction();
                                    }
                                }
                            }
                            if (!stop) {
                                int mountHD_error = 0;
                                Trace.trace(TRACE_MASKF, "Mount the Hard Drive upgrade partition");
                                mountHD_error = this.mountHardDrive();
                                Trace.trace(TRACE_MASKF, "mountHD_error is : " + mountHD_error);
                                if (mountHD_error != 0) {
                                    stop = true;
                                    this.saveupgradeMessages(mountHD_error);
                                    try {
                                        Trace.trace(TRACE_MASKF, "Unmount hard drive");
                                        this.upgrDevice.unmount();
                                        this.upgrDevice.unlock();
                                    }
                                    catch (Exception e) {
                                        Trace.trace(TRACE_MASKF, "An Exception on unmounting Hard drive");
                                        Trace.trace(TRACE_MASKT, "<-> Error message is : " + e.getMessage());
                                    }
                                    if (radiobutton.equals("DVDItem")) {
                                        try {
                                            Trace.trace(TRACE_MASKF, "Unmount DVD");
                                            this.upgrDeviceDVD.unmount();
                                            this.upgrDeviceDVD.unlock();
                                        }
                                        catch (Exception e) {
                                            Trace.trace(TRACE_MASKF, "An Exception on unmounting DVD");
                                            Trace.trace(TRACE_MASKT, "<-> Error message is : " + e.getMessage());
                                        }
                                    }
                                    if (mountHD_error == 5 || mountHD_error == 10 || mountHD_error == 12) {
                                        taskletResponse.terminate();
                                    } else {
                                        taskletResponse.noAction();
                                    }
                                }
                            } else {
                                Trace.trace(TRACE_MASKF, "stop is : " + stop + " at mount of " + "linux upgrade partition");
                            }
                            if (!stop) {
                                boolean shutdown = false;
                                if (checkbox.equals("YES_CHECK")) {
                                    Trace.trace(TRACE_MASKF, "Checkbox found tasklet side.");
                                }
                                if (shutdown) {
                                    Trace.trace(TRACE_MASKF, "tracestop for shutdown.");
                                    stop = true;
                                    taskletResponse.noAction();
                                }
                            } else {
                                Trace.trace(TRACE_MASKF, "stop is : " + stop + " at shut down hmc");
                            }
                            if (!stop) {
                                LocalizableText title;
                                int returnStatus;
                                if (radiobutton.equals("HardDriveItem") || radiobutton.equals("HMCItem")) {
                                    Trace.trace(TRACE_MASKF, "HardDrive radio button found tasklet side.");
                                    Trace.trace(TRACE_MASKF, "Save to harddrive will be done.");
                                    returnStatus = 0;
                                    title = new LocalizableText(RES_BUNDLE_NAME, PANEL_TITLE);
                                    LocalizableText msg = new LocalizableText(RES_BUNDLE_NAME, BUSY_MSG1);
                                    this.showBusyDialog(title, msg);
                                    Trace.trace(TRACE_MASKF, "Call Saveupgradeharddrive");
                                    returnStatus = this.saveupgradeHarddrive();
                                    Trace.trace(TRACE_MASKF, "Return from saveupgradeHarddrive");
                                    Trace.trace(TRACE_MASKF, "returnStatus is : " + returnStatus);
                                    Trace.trace(TRACE_MASKF, "Unmount Hard drive");
                                    try {
                                        this.upgrDevice.unmount();
                                        this.upgrDevice.unlock();
                                    }
                                    catch (MediaDeviceException e) {
                                        Trace.trace(TRACE_MASKF, "Media Device exception Unmount Hard drive");
                                    }
                                    Trace.trace(TRACE_MASKF, "About to destroy busy dialog box");
                                    Thread.currentThread();
                                    Thread.sleep(5000L);
                                    this.destroyBusyDialog();
                                    if (returnStatus == 0) {
                                        if (User.getUser().hasAuth("base.rolegroup.pedebug")) {
                                            Trace.trace(TRACE_MASKF, "User is PEDEBUG mode.");
                                            int mountDOS_error = 0;
                                            Trace.trace(TRACE_MASKF, "Mount the DOS partition");
                                            mountDOS_error = this.writeRestorelstDOS();
                                            Trace.trace(TRACE_MASKF, "mountDOS_error is : " + mountDOS_error);
                                            if (mountDOS_error != 0) {
                                                Trace.trace(TRACE_MASKF, "mountDOS_error is : " + mountDOS_error);
                                            }
                                        } else {
                                            Trace.trace(TRACE_MASKF, "User is NOT PEDEBUG mode.");
                                        }
                                        Trace.trace(TRACE_MASKF, "Create system event log.");
                                        new SystemEventLog(new FrameworkEventText(751), "SAVE_UPGRADE_DATA").log();
                                        Trace.trace(TRACE_MASKF, "System event log created.");
                                        this.saveupgradeMessages(6);
                                    } else {
                                        this.saveupgradeMessages(5);
                                    }
                                    taskletResponse.terminate();
                                    break block48;
                                }
                                Trace.trace(TRACE_MASKF, "DVD radio button found tasklet side.");
                                Trace.trace(TRACE_MASKF, "Save to DVD will be done.");
                                returnStatus = 0;
                                title = new LocalizableText(RES_BUNDLE_NAME, PANEL_TITLE);
                                LocalizableText msg = new LocalizableText(RES_BUNDLE_NAME, BUSY_MSG1);
                                this.showBusyDialog(title, msg);
                                Trace.trace(TRACE_MASKF, "Call Saveupgradeharddrive");
                                returnStatus = this.saveupgradeHarddrive();
                                Trace.trace(TRACE_MASKF, "Return from saveupgradeHarddrive");
                                if (returnStatus == 0) {
                                    try {
                                        int count;
                                        String fileRead = this.upgrDevice.getMountPoint().getAbsolutePath() + "/uplinux/" + this.fileNameZip;
                                        Trace.trace(TRACE_MASKF, "fileRead is : " + fileRead);
                                        String fileWrite = this.upgrDeviceDVD.getMountPoint().getAbsolutePath() + "/uplinux/" + this.fileNameZip;
                                        Trace.trace(TRACE_MASKF, "fileWrite is : " + fileWrite);
                                        FileInputStream in = new FileInputStream(fileRead);
                                        FileOutputStream out = new FileOutputStream(fileWrite);
                                        byte[] buf = new byte[1024];
                                        while ((count = in.read(buf)) > 0) {
                                            void var15_28;
                                            out.write(buf, 0, (int)var15_28);
                                        }
                                        in.close();
                                        out.close();
                                    }
                                    catch (IOException e) {
                                        Trace.trace(TRACE_MASKF, "IOException on writing of file to DVD");
                                        Trace.trace(TRACE_MASKT, "<-> Error message is : " + e.getMessage());
                                        HException hexc = new HException(e);
                                        Trace.trace(TRACE_MASKF, "Caught IOException writing to DVD");
                                        returnStatus = 5;
                                        new FrameworkLog(_logInfo, 16413, hexc).log();
                                    }
                                }
                                Trace.trace(TRACE_MASKF, "Unmount Hard drive and DVD");
                                try {
                                    this.upgrDevice.unmount();
                                    this.upgrDevice.unlock();
                                    this.upgrDeviceDVD.unmount();
                                    this.upgrDeviceDVD.unlock();
                                }
                                catch (MediaDeviceException e) {
                                    Trace.trace(TRACE_MASKF, "Media Device exception Unmount Hard drive and DVD");
                                }
                                Trace.trace(TRACE_MASKF, "About to destroy busy dialog box");
                                Thread.currentThread();
                                Thread.sleep(5000L);
                                this.destroyBusyDialog();
                                if (returnStatus == 0) {
                                    if (User.getUser().hasAuth("base.rolegroup.pedebug")) {
                                        Trace.trace(TRACE_MASKF, "User is PEDEBUG mode.");
                                        int mountDOS_error = 0;
                                        Trace.trace(TRACE_MASKF, "Mount the DOS partition");
                                        mountDOS_error = this.writeRestorelstDOS();
                                        Trace.trace(TRACE_MASKF, "mountDOS_error is : " + mountDOS_error);
                                        if (mountDOS_error != 0) {
                                            Trace.trace(TRACE_MASKF, "mountDOS_error is : " + mountDOS_error);
                                        }
                                    } else {
                                        Trace.trace(TRACE_MASKF, "User is NOT PEDEBUG mode.");
                                    }
                                    Trace.trace(TRACE_MASKF, "Create system event log.");
                                    new SystemEventLog(new FrameworkEventText(751), "SAVE_UPGRADE_DATA").log();
                                    Trace.trace(TRACE_MASKF, "System event log created.");
                                    this.saveupgradeMessages(2);
                                } else {
                                    this.saveupgradeMessages(5);
                                }
                                taskletResponse.terminate();
                                break block48;
                            }
                            Trace.trace(TRACE_MASKF, "stop is : " + stop + " for save button DVD or HD");
                        }
                        catch (Exception exc) {
                            HException hexc = new HException(exc);
                            new FrameworkLog(_logInfo, 16394, hexc).log();
                            Trace.trace(TRACE_MASKF, "Caught Exception in saveupgradeMessages(int message)" + exc);
                        }
                    } else {
                        Trace.trace(TRACE_MASKT, "Unknown tasklet request sent to the UpgradeDataTasklet.");
                        taskletResponse.terminate();
                    }
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- UpgradeDataTasklet.service()");
    }

    public void saveupgradeMessages(int message) {
        Trace.trace(TRACE_MASKT, "-> UpgradeDataTasklet.saveupgradeMessages(int message)");
        int choice = message;
        MessageText[] text = new BaseMessageText[1];
        BaseMessageTitle title = null;
        String msgId = null;
        try {
            switch (choice) {
                case 2: {
                    Trace.trace(TRACE_MASKF, "Do setup for Save to DVD Successful Panel");
                    title = new BaseMessageTitle("SAV80002");
                    text[0] = new BaseMessageText("SAV00002I");
                    Trace.trace(TRACE_MASKF, "Setup complete for Save to DVD Successful Panel");
                    break;
                }
                case 3: {
                    Trace.trace(TRACE_MASKF, "Do setup for DVD not ready panel");
                    title = new BaseMessageTitle("SAV80003");
                    text[0] = new BaseMessageText("SAV00003E");
                    Trace.trace(TRACE_MASKF, "Setup complete for DVD not ready panel");
                    break;
                }
                case 4: {
                    Trace.trace(TRACE_MASKF, "Do setup for DVD write protected panel");
                    title = new BaseMessageTitle("SAV80004");
                    text[0] = new BaseMessageText("SAV00004E");
                    Trace.trace(TRACE_MASKF, "Setup complete for DVD write protected panel");
                    break;
                }
                case 5: {
                    Trace.trace(TRACE_MASKF, "Do setup for Error exception occurred message");
                    title = new BaseMessageTitle("SAV80005");
                    text[0] = new BaseMessageText("SAV00005E");
                    Trace.trace(TRACE_MASKF, "Setup complete for Error saving to media panel");
                    break;
                }
                case 6: {
                    Trace.trace(TRACE_MASKF, "Do setup for Save to HardDrive Successfully Panel");
                    title = new BaseMessageTitle("SAV80002");
                    text[0] = new BaseMessageText("SAV00006I");
                    Trace.trace(TRACE_MASKF, "Setup complete for Save to HardDrive Successfully Panel");
                    break;
                }
                case 7: {
                    Trace.trace(TRACE_MASKF, "Do setup for DVD not supported panel");
                    title = new BaseMessageTitle(PANEL_TITLE);
                    text[0] = new BaseMessageText("SAV00007I");
                    Trace.trace(TRACE_MASKF, "Setup complete for DVD not supported panel");
                    break;
                }
                case 8: {
                    Trace.trace(TRACE_MASKF, "Do setup for DVD not functional panel");
                    title = new BaseMessageTitle(PANEL_TITLE);
                    text[0] = new BaseMessageText("SAV00008I");
                    Trace.trace(TRACE_MASKF, "Setup complete for DVD not functional panel");
                    break;
                }
                case 9: {
                    Trace.trace(TRACE_MASKF, "Do setup for not all data saved panel");
                    title = new BaseMessageTitle("SAV80005");
                    text[0] = new BaseMessageText("SAV00009I");
                    Trace.trace(TRACE_MASKF, "Setup complete for not all data saved panel");
                    break;
                }
                case 10: {
                    Trace.trace(TRACE_MASKF, "Do setup for media device locked panel");
                    title = new BaseMessageTitle("SAV80005");
                    text[0] = new BaseMessageText("SAV00010I");
                    Trace.trace(TRACE_MASKF, "Setup complete for media device locked panel");
                    break;
                }
                case 11: {
                    Trace.trace(TRACE_MASKF, "Do setup for wrong DVD label panel");
                    title = new BaseMessageTitle("SAV80005");
                    text[0] = new BaseMessageText("SAV00011I");
                    Trace.trace(TRACE_MASKF, "Setup complete for wrong DVD label panel");
                    break;
                }
                case 12: {
                    Trace.trace(TRACE_MASKF, "Do setup for error mounting upgrade partition panel");
                    title = new BaseMessageTitle("SAV80005");
                    text[0] = new BaseMessageText("SAV00012E");
                    Trace.trace(TRACE_MASKF, "Setup complete for error mounting upgrade partition panel");
                    break;
                }
                default: {
                    HException hexc = new HException("Unknown error");
                    Trace.trace(TRACE_MASKF, hexc);
                    Trace.trace(TRACE_MASKF, "Return code from Server does not match message box case number." + hexc);
                    new FrameworkLog(_logInfo, 16396, hexc).log();
                    break;
                }
            }
            Trace.trace(TRACE_MASKF, "message to be displayed is : " + text[0].toString());
            this.showMessageBox(true, title, text, msgId, null, null);
        }
        catch (Exception exc) {
            HException hexc = new HException(exc);
            Trace.trace(TRACE_MASKF, "Caught Excecption in saveupgradeMessages(int message)" + exc);
            new FrameworkLog(_logInfo, 16397, hexc).log();
        }
        Trace.trace(TRACE_MASKT, "<- UpgradeDataTasklet.saveupgradeMessages(int message)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public int saveupgradeHarddrive() {
        byte[] buf = new byte[1024];
        int status = 0;
        ZipOutputStream zos = null;
        Trace.trace(TRACE_MASKT, "-> UpgradeDataTasklet.saveupgradeHarddrive()");
        try {
            String upgradePath = BaseFileControl.getFilePath(this.fileNameZip);
            Trace.trace(TRACE_MASKF, "upgradePath is : " + upgradePath);
            File f1 = new File(upgradePath);
            boolean path_Check = f1.exists();
            if (f1.exists()) {
                Trace.trace(TRACE_MASKF, "Path " + upgradePath + "exists");
                Trace.trace(TRACE_MASKF, "Delete all files that start with UpgradeData");
                UpgradeDataFilter only = new UpgradeDataFilter();
                String[] foundFiles = f1.list(only);
                int i = 0;
                while (i < foundFiles.length) {
                    Trace.trace(TRACE_MASKF, "Delete file : " + upgradePath + foundFiles[i]);
                    f1 = new File(upgradePath + foundFiles[i]);
                    f1.delete();
                    ++i;
                }
            } else {
                Trace.trace(TRACE_MASKF, "Path " + upgradePath + "does not exist create it");
                f1.mkdirs();
                if (f1.exists()) {
                    Trace.trace(TRACE_MASKF, "Path " + upgradePath + "exists");
                } else {
                    Trace.trace(TRACE_MASKF, "Path " + upgradePath + "was not created");
                }
            }
            String fullFileNameZip = upgradePath + this.fileNameZip;
            Trace.trace(TRACE_MASKF, "fullFileNameZip is : " + fullFileNameZip);
            zos = new ZipOutputStream(new FileOutputStream(fullFileNameZip));
            zos.setMethod(8);
            zos.setComment("compressed");
            ZipEntry ze1 = new ZipEntry(this.fileNameZip);
            ze1.setSize(this.fileNameZip.length());
            zos.putNextEntry(ze1);
            zos.write(this.fileNameZip.getBytes(), 0, this.fileNameZip.length());
            Trace.trace(TRACE_MASKF, "Zip file stream " + fullFileNameZip + " opened");
            Trace.trace(TRACE_MASKF, "About to getUtility list from Tower");
            String versionNumber = null;
            this.implList = new ArrayList();
            ClassId towers = new ClassId("com.ibm.hwmca.fw.managed", "Tower");
            Set inventory = ManagedObjectManager.getManagedObjectManager().getInventory(towers);
            Trace.trace(TRACE_MASKF, "inventory size: " + inventory.size());
            Iterator iterator = inventory.iterator();
            while (iterator.hasNext()) {
                HwmcaObject obj = (HwmcaObject)iterator.next();
                if (!(obj instanceof Tower)) continue;
                Trace.trace(TRACE_MASKF, "found a tower");
                Trace.trace(TRACE_MASKF, "Create impl object");
                Object impl = ((Tower)obj).getInterfaceImpl(Class.forName(INTERFACE_NAME));
                Trace.trace(TRACE_MASKF, "impl object created");
                if (impl == null) continue;
                Trace.trace(TRACE_MASKF, "adding an impl");
                this.implList.add(impl);
                impl = null;
            }
            Trace.trace(TRACE_MASKF, "There are " + this.implList.size() + " tower(s) registered");
            Iterator i = this.implList.iterator();
            while (i.hasNext()) {
                int len;
                Trace.trace(TRACE_MASKF, "Make UpgradeData class for tower being used");
                UpgradeData implClass = (UpgradeData)i.next();
                Trace.trace(TRACE_MASKF, "Create class class1 and get class name.");
                Class<?> class1 = implClass.getClass();
                String classNameRunning = class1.getName();
                try {
                    Trace.trace(TRACE_MASKF, "Class Name running is : " + classNameRunning);
                    Trace.trace(TRACE_MASKF, "Call getUpgradeDataVersion to return version number");
                    versionNumber = implClass.getUpgradeDataVersion();
                }
                catch (UpgradeDataException e) {
                    Trace.trace(TRACE_MASKF, "Caught UpgradeData Exception in saveupgradeHarddrive.getUpgradeDataVersion()" + e);
                    if (e.isCriticalDataError()) {
                        Trace.trace(TRACE_MASKF, "Critical Data error flag is set ");
                        status = 5;
                        new FrameworkLog(_logInfo, 16411, e).log();
                    }
                    status = 0;
                }
                Trace.trace(TRACE_MASKF, "Version Number returned is : " + versionNumber);
                String fulltowerName = this.filePrefix + classNameRunning + "!" + versionNumber;
                Trace.trace(TRACE_MASKF, "Full tower name is : " + fulltowerName);
                String path = BaseFileControl.getFilePath(fulltowerName) + fulltowerName;
                Trace.trace(TRACE_MASKF, "path is : " + path);
                File fileobject = new File(path);
                if (fileobject.exists()) {
                    Trace.trace(TRACE_MASKF, "Zip File " + fileobject.getAbsolutePath() + " exists");
                    fileobject.delete();
                    if (fileobject.exists()) {
                        Trace.trace(TRACE_MASKF, "File " + fileobject.getAbsolutePath() + " was not deleted");
                    } else {
                        Trace.trace(TRACE_MASKF, "File " + path + " was deleted");
                    }
                }
                Trace.trace(TRACE_MASKF, "Open Tower file Output stream " + path);
                FileOutputStream zTowerOut = new FileOutputStream(path);
                Trace.trace(TRACE_MASKF, "Tower file Output stream " + path + " opened");
                try {
                    Trace.trace(TRACE_MASKF, "Call saveUpgrade(StreamNameOut)");
                    implClass.saveUpgradeData(zTowerOut);
                }
                catch (UpgradeDataException e) {
                    Trace.trace(TRACE_MASKF, "Caught Class Not Found Exception in saveupgradeHarddrive().saveUpgradeData()" + e);
                    if (e.isCriticalDataError()) {
                        Trace.trace(TRACE_MASKF, "Critical Data error flag is set ");
                        status = 5;
                        new FrameworkLog(_logInfo, 16412, e).log();
                    }
                    status = 0;
                }
                Trace.trace(TRACE_MASKF, "Return from saveUpgrade(StreamNameOut)");
                Trace.trace(TRACE_MASKF, "Close Tower file output stream " + path);
                zTowerOut.close();
                Trace.trace(TRACE_MASKF, "Tower file Output stream " + path + " closed");
                fileobject = new File(path);
                if (!fileobject.exists()) continue;
                Trace.trace(TRACE_MASKF, "Zip File " + fileobject.getAbsolutePath() + " exists");
                String str = path;
                fileobject = new File(str);
                ZipEntry ze = new ZipEntry(str);
                FileInputStream is = new FileInputStream(str);
                Trace.trace(TRACE_MASKF, "str File length is : " + fileobject.length());
                Trace.trace(TRACE_MASKF, "Zip entry created");
                zos.putNextEntry(ze);
                Trace.trace(TRACE_MASKF, "Entry written to zip File");
                while ((len = is.read(buf)) >= 0) {
                    void var2_24;
                    zos.write(buf, 0, (int)var2_24);
                }
                Trace.trace(TRACE_MASKF, "File " + str + " written to Zip file");
                is.close();
            }
        }
        catch (ClassNotFoundException e) {
            Trace.trace(TRACE_MASKF, "Caught Class Not Found Exception in saveupgradeHarddrive()" + e);
            status = 5;
            new FrameworkLog(_logInfo, 16410, e).log();
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "Caught IO Exception in saveupgradeHarddrive()" + e);
            status = 5;
            new FrameworkLog(_logInfo, 16409, e).log();
        }
        catch (HException e) {
            Trace.trace(TRACE_MASKF, "Caught HException in saveupgradeHarddrive()" + e);
            status = 5;
            new FrameworkLog(_logInfo, 16407, e).log();
        }
        finally {
            Trace.trace(TRACE_MASKF, "Doing final cleanup for UpgradeDataTasklet.saveupgradeHarddrive()");
            try {
                zos.close();
                Trace.trace(TRACE_MASKF, "zip file closed.");
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "Exception in final cleanup for UpgradeDataTasklet.saveupgradeHarddrive()");
            }
        }
        Trace.trace(TRACE_MASKT, "<- UpgradeDataTasklet.saveupgradeHarddrive()");
        return status;
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "-> UpgradeDataTasklet.logException()");
        Trace.trace(TRACE_MASKT, "processing exception: " + throwable);
        HException hexc = new HException(throwable);
        new FrameworkLog(_logInfo, 16395, hexc).log();
        Trace.trace(TRACE_MASKT, "<- UpgradeDataTasklet.logException()");
    }

    public int mountHardDrive() {
        int mountHD_error = 0;
        String mount_harddrive = null;
        Trace.trace(TRACE_MASKT, "-> UpgradeDataTasklet.mountHardDrive()");
        try {
            Trace.trace(TRACE_MASKF, "Create class MediaServices");
            MediaServices ms = MediaServices.getMediaServices();
            MediaDeviceIdentifier upgrMediaId = ms.getPreferredDevice(4);
            this.upgrDevice = ms.requestLock(new LocalizableText("Save Upgrade Data Hard Drive"), upgrMediaId);
            Trace.trace(TRACE_MASKF, "Mount read write HardDrive");
            this.upgrDevice.mountReadWrite();
            Trace.trace(TRACE_MASKF, "Read write HardDrive mounted");
            Trace.trace(TRACE_MASKF, "Get mount point of HardDrive");
            mount_harddrive = this.upgrDevice.getMountPoint().getAbsolutePath();
            Trace.trace(TRACE_MASKF, "mount_harddrive mount point is = " + mount_harddrive);
            String upgradePath = BaseFileControl.getFilePath(this.fileNameZip);
            Trace.trace(TRACE_MASKF, "upgradePath is : " + upgradePath);
            File f1 = new File(upgradePath);
            if (f1.exists()) {
                Trace.trace(TRACE_MASKF, "Path " + upgradePath + "exists");
            } else {
                Trace.trace(TRACE_MASKF, "Path " + upgradePath + "does not exist create it");
                f1.mkdirs();
                if (f1.exists()) {
                    Trace.trace(TRACE_MASKF, "Path " + upgradePath + "exists");
                } else {
                    Trace.trace(TRACE_MASKF, "Path " + upgradePath + "was not created");
                }
            }
            Trace.trace(TRACE_MASKF, "mount_harddrive is = " + mount_harddrive);
        }
        catch (IllegalArgumentException e) {
            Trace.trace(TRACE_MASKT, "<-> UpgradeDataTasklet.mountHardDrive.IllegalArgumentException");
            Trace.trace(TRACE_MASKT, "<-> Error message is : " + e.getMessage());
            mountHD_error = 5;
            new FrameworkLog(_logInfo, 16398, e).log();
        }
        catch (MediaDeviceLockException e) {
            Trace.trace(TRACE_MASKT, "<-> UpgradeDataTasklet.mountHardDrive.MediaDeviceLockException");
            Trace.trace(TRACE_MASKT, "<-> Error message is : " + e.getMessage());
            mountHD_error = 10;
        }
        catch (MediaWriteProtectedException e) {
            Trace.trace(TRACE_MASKT, "<-> UpgradeDataTasklet.mountHardDrive.MediaWriteProtectedException");
            Trace.trace(TRACE_MASKT, "<-> Error message is : " + e.getMessage());
            mountHD_error = 5;
            new FrameworkLog(_logInfo, 16404, e).log();
        }
        catch (NoMediaPresentException e) {
            Trace.trace(TRACE_MASKT, "<-> UpgradeDataTasklet.mountHardDrive.NoMediaPresentException");
            Trace.trace(TRACE_MASKT, "<-> Error message is : " + e.getMessage());
            mountHD_error = 5;
            new FrameworkLog(_logInfo, 16405, e).log();
        }
        catch (MediaDeviceException e) {
            Trace.trace(TRACE_MASKT, "<-> UpgradeDataTasklet.mountHardDrive.MediaDeviceException");
            Trace.trace(TRACE_MASKT, "<-> Error message is : " + e.getMessage());
            mountHD_error = 12;
            new FrameworkLog(_logInfo, 16401, e).log();
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "<-> UpgradeDataTasklet.mountHD.Exception");
            Trace.trace(TRACE_MASKT, "<-> Error message is : " + e.getMessage());
            mountHD_error = 5;
            new FrameworkLog(_logInfo, 16406, e).log();
        }
        Trace.trace(TRACE_MASKT, "<- UpgradeDataTasklet.mountHardDrive()");
        return mountHD_error;
    }

    public int mountDVD() {
        int mountDVD_error = 0;
        String mount_dvd = null;
        Trace.trace(TRACE_MASKT, "-> UpgradeDataTasklet.mountDVD()");
        try {
            Trace.trace(TRACE_MASKF, "Before creating class mediaServices");
            MediaServices msDVD = MediaServices.getMediaServices();
            Trace.trace(TRACE_MASKF, "After creating class mediaServices");
            MediaDeviceIdentifier upgrMediaIdDVD = msDVD.getPreferredDevice(6);
            this.upgrDeviceDVD = msDVD.requestLock(new LocalizableText("Save Upgrade Data DVD Drive"), upgrMediaIdDVD);
            Trace.trace(TRACE_MASKT, "<-> Get DVD label");
            String label_DVD = this.upgrDeviceDVD.getLabel();
            Trace.trace(TRACE_MASKT, "<-> DVD is : " + label_DVD);
            if (label_DVD != null) {
                if (!this.upgrDeviceDVD.getLabel().equals("ACTBKP")) {
                    throw new MediaDeviceException("wrong label");
                }
            } else {
                throw new MediaDeviceException("wrong label");
            }
            Trace.trace(TRACE_MASKF, "Mount DVD read write");
            this.upgrDeviceDVD.mountReadWrite();
            Trace.trace(TRACE_MASKF, "DVD mounted read write");
            Trace.trace(TRACE_MASKF, "Get DVD mount point");
            mount_dvd = this.upgrDeviceDVD.getMountPoint().getAbsolutePath();
            Trace.trace(TRACE_MASKF, "Mount point DVD is :" + mount_dvd);
            String upgradePath = this.upgrDeviceDVD.getMountPoint().getAbsolutePath() + "/uplinux/";
            Trace.trace(TRACE_MASKF, "upgradePath is : " + upgradePath);
            File f1DVD = new File(upgradePath);
            if (f1DVD.exists()) {
                Trace.trace(TRACE_MASKF, "Path " + upgradePath + "exists");
            } else {
                Trace.trace(TRACE_MASKF, "Path " + upgradePath + "does not exist create it");
                f1DVD.mkdirs();
                if (f1DVD.exists()) {
                    Trace.trace(TRACE_MASKF, "Path " + upgradePath + "exists");
                } else {
                    Trace.trace(TRACE_MASKF, "Path " + upgradePath + "was not created");
                }
            }
            Trace.trace(TRACE_MASKF, "mount_dvd is = " + mount_dvd);
            Trace.trace(TRACE_MASKT, "<-> UpgradeDataTasklet get label DVD");
            label_DVD = this.upgrDeviceDVD.getLabel();
            Trace.trace(TRACE_MASKT, "<-> UpgradeDataTasklet label is : " + label_DVD);
        }
        catch (IllegalArgumentException e) {
            Trace.trace(TRACE_MASKT, "<-> UpgradeDataTasklet.mountDVD.IllegalArgumentException");
            Trace.trace(TRACE_MASKT, "<-> Error message is : " + e.getMessage());
            mountDVD_error = 5;
            new FrameworkLog(_logInfo, 16400, e).log();
        }
        catch (MediaDeviceLockException e) {
            Trace.trace(TRACE_MASKT, "<-> UpgradeDataTasklet.mountDVD.MediaDeviceLockException");
            Trace.trace(TRACE_MASKT, "<-> Error message is : " + e.getMessage());
            mountDVD_error = 10;
        }
        catch (MediaWriteProtectedException e) {
            Trace.trace(TRACE_MASKT, "<-> UpgradeDataTasklet.mountDVD.MediaWriteProtectedException");
            Trace.trace(TRACE_MASKT, "<-> Error message is : " + e.getMessage());
            mountDVD_error = 4;
        }
        catch (NoMediaPresentException e) {
            Trace.trace(TRACE_MASKT, "<-> UpgradeDataTasklet.mountDVD.NoMediaPresentException");
            Trace.trace(TRACE_MASKT, "<-> Error message is : " + e.getMessage());
            mountDVD_error = 3;
        }
        catch (MediaDeviceException e) {
            Trace.trace(TRACE_MASKT, "<-> UpgradeDataTasklet.mountDVD.MediaDeviceException");
            Trace.trace(TRACE_MASKT, "<-> Error message is : " + e.getMessage());
            if (e.getMessage().equals("wrong label")) {
                mountDVD_error = 11;
            } else {
                mountDVD_error = 8;
                new FrameworkLog(_logInfo, 16402, e).log();
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "<-> UpgradeDataTasklet.mountDVD.Exception");
            Trace.trace(TRACE_MASKT, "<-> Error message is : " + e.getMessage());
            mountDVD_error = 5;
            new FrameworkLog(_logInfo, 16403, e).log();
        }
        Trace.trace(TRACE_MASKT, "<- UpgradeDataTasklet.mountDVD()");
        return mountDVD_error;
    }

    public int writeRestorelstDOS() {
        int mountHD_error = 0;
        String mount_harddriveDOS = null;
        MediaDeviceIdentifier upgrMediaId = null;
        Trace.trace(TRACE_MASKT, "-> UpgradeDataTasklet.writeRestorelstDOS()");
        try {
            Trace.trace(TRACE_MASKF, "Create class MediaServices");
            MediaServices ms = MediaServices.getMediaServices();
            MediaDeviceIdentifier[] mdis = ms.getMediaDeviceIdentifiers(4);
            if (mdis.length > 1) {
                Trace.trace(TRACE_MASKF, "There are at least 2 hard drive partitions");
                int i = 0;
                while (i < mdis.length) {
                    if (mdis[i].getInternalDeviceName().equals("dos")) {
                        Trace.trace(TRACE_MASKF, "Drive " + mdis[i] + " found");
                        Trace.trace(TRACE_MASKF, mdis[i]);
                        upgrMediaId = mdis[i];
                    }
                    ++i;
                }
                if (upgrMediaId == null) {
                    Trace.trace(TRACE_MASKF, "upgrMediaId DOS is null");
                    upgrMediaId = ms.getPreferredDevice(1);
                }
            } else {
                Trace.trace(TRACE_MASKF, "There is only 1 hard drive partition");
                upgrMediaId = ms.getPreferredDevice(1);
            }
            this.upgrDeviceDOS = ms.requestLock(new LocalizableText("Save Upgrade Data Hard Drive DOS"), upgrMediaId);
            Trace.trace(TRACE_MASKF, "Mount DOS read write HardDrive");
            this.upgrDeviceDOS.mountReadWrite();
            Trace.trace(TRACE_MASKF, "DOS Read write HardDrive mounted");
            Trace.trace(TRACE_MASKF, "Get mount point of DOS HardDrive");
            mount_harddriveDOS = this.upgrDeviceDOS.getMountPoint().getAbsolutePath();
            Trace.trace(TRACE_MASKF, "DOS mount_harddrive mount point is = " + mount_harddriveDOS);
            String restoreFile = this.upgrDeviceDOS.getMountPoint().getAbsolutePath() + "/linos2/restore.lst";
            Trace.trace(TRACE_MASKF, "full name in restoreFile is :" + restoreFile);
            FileWriter fileRestore = new FileWriter(restoreFile);
            fileRestore.write("HARDDRIVE");
            fileRestore.close();
            Trace.trace(TRACE_MASKF, "Unmount DOS partition");
            this.upgrDeviceDOS.unmount();
            this.upgrDeviceDOS.unlock();
        }
        catch (IllegalArgumentException e) {
            Trace.trace(TRACE_MASKT, "<-> UpgradeDataTasklet.writeRestorelstDOS.IllegalArgumentException");
            Trace.trace(TRACE_MASKT, "<-> Error message is : " + e.getMessage());
            mountHD_error = 15;
            new FrameworkLog(_logInfo, 16414, e).log();
        }
        catch (MediaDeviceLockException e) {
            Trace.trace(TRACE_MASKT, "<-> UpgradeDataTasklet.writeRestorelstDOS.MediaDeviceLockException");
            Trace.trace(TRACE_MASKT, "<-> Error message is : " + e.getMessage());
            mountHD_error = 10;
        }
        catch (MediaWriteProtectedException e) {
            Trace.trace(TRACE_MASKT, "<-> UpgradeDataTasklet.writeRestorelstDOS.MediaWriteProtectedException");
            Trace.trace(TRACE_MASKT, "<-> Error message is : " + e.getMessage());
            mountHD_error = 15;
            new FrameworkLog(_logInfo, 16416, e).log();
        }
        catch (NoMediaPresentException e) {
            Trace.trace(TRACE_MASKT, "<-> UpgradeDataTasklet.writeRestorelstDOS.NoMediaPresentException");
            Trace.trace(TRACE_MASKT, "<-> Error message is : " + e.getMessage());
            mountHD_error = 15;
            new FrameworkLog(_logInfo, 16417, e).log();
        }
        catch (MediaDeviceException e) {
            Trace.trace(TRACE_MASKT, "<-> UpgradeDataTasklet.writeRestorelstDOS.MediaDeviceException");
            Trace.trace(TRACE_MASKT, "<-> Error message is : " + e.getMessage());
            try {
                Trace.trace(TRACE_MASKF, "unlock DOS partition");
                this.upgrDeviceDOS.unlock();
                Trace.trace(TRACE_MASKF, "DOS partition unlocked.");
            }
            catch (Exception e1) {
                Trace.trace(TRACE_MASKF, "Exception in final cleanup for UpgradeDataTasklet.writeRestorelstDOS()");
            }
            mountHD_error = 12;
            new FrameworkLog(_logInfo, 16415, e).log();
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "<-> UpgradeDataTasklet.writeRestorelstDOS.Exception");
            Trace.trace(TRACE_MASKT, "<-> Error message is : " + e.getMessage());
            mountHD_error = 15;
            new FrameworkLog(_logInfo, 16418, e).log();
        }
        Trace.trace(TRACE_MASKT, "<- UpgradeDataTasklet.writeRestorelstDOS()");
        return mountHD_error;
    }

    public String getUpgradeDataPlatform() {
        Trace.trace(TRACE_MASKT, "-> UpgradeDataTasklet.getUpgradeDataPlatform()");
        Trace.trace(TRACE_MASKF, "Platform is : " + this.Platform);
        Trace.trace(TRACE_MASKT, "<- UpgradeDataTasklet.getUpgradeDataPlatform()");
        return this.Platform;
    }
}

